function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var application_common_1 = require("./application-common");
__export(require("./application-common"));
var builder_1 = require("../ui/builder");
var view_1 = require("../ui/core/view");
var frame_1 = require("../ui/frame");
var utils = require("../utils/utils");
var profiling_1 = require("../profiling");
var Responder = (function (_super) {
    __extends(Responder, _super);
    function Responder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return Responder;
}(UIResponder));
var NotificationObserver = (function (_super) {
    __extends(NotificationObserver, _super);
    function NotificationObserver() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NotificationObserver.initWithCallback = function (onReceiveCallback) {
        var observer = _super.new.call(this);
        observer._onReceiveCallback = onReceiveCallback;
        return observer;
    };
    NotificationObserver.prototype.onReceive = function (notification) {
        this._onReceiveCallback(notification);
    };
    NotificationObserver.ObjCExposedMethods = {
        "onReceive": { returns: interop.types.void, params: [NSNotification] }
    };
    return NotificationObserver;
}(NSObject));
var displayedOnce = false;
var displayedLinkTarget;
var displayedLink;
var CADisplayLinkTarget = (function (_super) {
    __extends(CADisplayLinkTarget, _super);
    function CADisplayLinkTarget() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CADisplayLinkTarget.prototype.onDisplayed = function (link) {
        link.invalidate();
        var ios = utils.ios.getter(UIApplication, UIApplication.sharedApplication);
        var object = iosApp;
        displayedOnce = true;
        application_common_1.notify({ eventName: application_common_1.displayedEvent, object: object, ios: ios });
        displayedLinkTarget = null;
        displayedLink = null;
    };
    CADisplayLinkTarget.ObjCExposedMethods = {
        "onDisplayed": { returns: interop.types.void, params: [CADisplayLink] }
    };
    return CADisplayLinkTarget;
}(NSObject));
var IOSApplication = (function () {
    function IOSApplication() {
        this._currentOrientation = utils.ios.getter(UIDevice, UIDevice.currentDevice).orientation;
        this._observers = new Array();
        this.addNotificationObserver(UIApplicationDidFinishLaunchingNotification, this.didFinishLaunchingWithOptions.bind(this));
        this.addNotificationObserver(UIApplicationDidBecomeActiveNotification, this.didBecomeActive.bind(this));
        this.addNotificationObserver(UIApplicationDidEnterBackgroundNotification, this.didEnterBackground.bind(this));
        this.addNotificationObserver(UIApplicationWillTerminateNotification, this.willTerminate.bind(this));
        this.addNotificationObserver(UIApplicationDidReceiveMemoryWarningNotification, this.didReceiveMemoryWarning.bind(this));
        this.addNotificationObserver(UIDeviceOrientationDidChangeNotification, this.orientationDidChange.bind(this));
    }
    Object.defineProperty(IOSApplication.prototype, "rootController", {
        get: function () {
            return this._window.rootViewController;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(IOSApplication.prototype, "nativeApp", {
        get: function () {
            return utils.ios.getter(UIApplication, UIApplication.sharedApplication);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(IOSApplication.prototype, "window", {
        get: function () {
            return this._window;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(IOSApplication.prototype, "delegate", {
        get: function () {
            return this._delegate;
        },
        set: function (value) {
            if (this._delegate !== value) {
                this._delegate = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(IOSApplication.prototype, "rootView", {
        get: function () {
            return this._rootView;
        },
        enumerable: true,
        configurable: true
    });
    IOSApplication.prototype.addNotificationObserver = function (notificationName, onReceiveCallback) {
        var observer = NotificationObserver.initWithCallback(onReceiveCallback);
        utils.ios.getter(NSNotificationCenter, NSNotificationCenter.defaultCenter).addObserverSelectorNameObject(observer, "onReceive", notificationName, null);
        this._observers.push(observer);
        return observer;
    };
    IOSApplication.prototype.removeNotificationObserver = function (observer, notificationName) {
        var index = this._observers.indexOf(observer);
        if (index >= 0) {
            this._observers.splice(index, 1);
            utils.ios.getter(NSNotificationCenter, NSNotificationCenter.defaultCenter).removeObserverNameObject(observer, notificationName, null);
        }
    };
    IOSApplication.prototype.didFinishLaunchingWithOptions = function (notification) {
        if (!displayedOnce && profiling_1.level() >= profiling_1.Level.lifecycle) {
            displayedLinkTarget = CADisplayLinkTarget.new();
            displayedLink = CADisplayLink.displayLinkWithTargetSelector(displayedLinkTarget, "onDisplayed");
            displayedLink.addToRunLoopForMode(NSRunLoop.mainRunLoop, NSDefaultRunLoopMode);
            displayedLink.addToRunLoopForMode(NSRunLoop.mainRunLoop, UITrackingRunLoopMode);
        }
        this._window = UIWindow.alloc().initWithFrame(utils.ios.getter(UIScreen, UIScreen.mainScreen).bounds);
        this._window.backgroundColor = utils.ios.getter(UIColor, UIColor.whiteColor);
        var args = {
            eventName: application_common_1.launchEvent,
            object: this,
            ios: notification.userInfo && notification.userInfo.objectForKey("UIApplicationLaunchOptionsLocalNotificationKey") || null
        };
        application_common_1.notify(args);
        application_common_1.notify({ eventName: "loadAppCss", object: this, cssFile: application_common_1.getCssFileName() });
        this.setWindowContent(args.root);
    };
    IOSApplication.prototype.didBecomeActive = function (notification) {
        var ios = utils.ios.getter(UIApplication, UIApplication.sharedApplication);
        var object = this;
        application_common_1.notify({ eventName: application_common_1.resumeEvent, object: object, ios: ios });
        var rootView = this._rootView;
        if (rootView && !rootView.isLoaded) {
            rootView.callLoaded();
        }
    };
    IOSApplication.prototype.didEnterBackground = function (notification) {
        application_common_1.notify({ eventName: application_common_1.suspendEvent, object: this, ios: utils.ios.getter(UIApplication, UIApplication.sharedApplication) });
        var rootView = this._rootView;
        if (rootView && rootView.isLoaded) {
            rootView.callUnloaded();
        }
    };
    IOSApplication.prototype.willTerminate = function (notification) {
        application_common_1.notify({ eventName: application_common_1.exitEvent, object: this, ios: utils.ios.getter(UIApplication, UIApplication.sharedApplication) });
        var rootView = this._rootView;
        if (rootView && rootView.isLoaded) {
            rootView.callUnloaded();
        }
    };
    IOSApplication.prototype.didReceiveMemoryWarning = function (notification) {
        application_common_1.notify({ eventName: application_common_1.lowMemoryEvent, object: this, ios: utils.ios.getter(UIApplication, UIApplication.sharedApplication) });
    };
    IOSApplication.prototype.orientationDidChange = function (notification) {
        var orientation = utils.ios.getter(UIDevice, UIDevice.currentDevice).orientation;
        if (this._currentOrientation !== orientation) {
            this._currentOrientation = orientation;
            var newValue = void 0;
            switch (orientation) {
                case 4:
                case 3:
                    newValue = "landscape";
                    break;
                case 1:
                case 2:
                    newValue = "portrait";
                    break;
                default:
                    newValue = "unknown";
                    break;
            }
            application_common_1.notify({
                eventName: application_common_1.orientationChangedEvent,
                ios: this,
                newValue: newValue,
                object: this
            });
        }
    };
    IOSApplication.prototype._onLivesync = function () {
        if (!this._rootView._onLivesync()) {
            this.setWindowContent();
        }
    };
    IOSApplication.prototype.setWindowContent = function (view) {
        if (this._rootView) {
            this._rootView._onRootViewReset();
        }
        var rootView = createRootView(view);
        this._rootView = rootView;
        var controller = getViewController(rootView);
        if (createRootFrame.value) {
            rootView._setupUI({});
        }
        else {
            rootView._setupAsRootView({});
        }
        var haveController = this._window.rootViewController !== null;
        this._window.rootViewController = controller;
        if (!haveController) {
            this._window.makeKeyAndVisible();
        }
    };
    __decorate([
        profiling_1.profile
    ], IOSApplication.prototype, "didFinishLaunchingWithOptions", null);
    __decorate([
        profiling_1.profile
    ], IOSApplication.prototype, "didBecomeActive", null);
    return IOSApplication;
}());
var iosApp = new IOSApplication();
exports.ios = iosApp;
application_common_1.setApplication(iosApp);
global.__onLiveSyncCore = function () {
    iosApp._onLivesync();
};
var mainEntry;
function createRootView(v) {
    var rootView = v;
    if (!rootView) {
        if (mainEntry) {
            if (createRootFrame.value) {
                var frame = rootView = new frame_1.Frame();
                frame.navigate(mainEntry);
            }
            else {
                rootView = builder_1.createViewFromEntry(mainEntry);
            }
        }
        else {
            throw new Error("A Frame must be used to navigate to a Page.");
        }
    }
    return rootView;
}
function getMainEntry() {
    return mainEntry;
}
exports.getMainEntry = getMainEntry;
function getRootView() {
    return iosApp.rootView;
}
exports.getRootView = getRootView;
var createRootFrame = { value: true };
var started = false;
function start(entry) {
    mainEntry = typeof entry === "string" ? { moduleName: entry } : entry;
    started = true;
    if (!iosApp.nativeApp) {
        UIApplicationMain(0, null, null, iosApp && iosApp.delegate ? NSStringFromClass(iosApp.delegate) : NSStringFromClass(Responder));
    }
    else {
        var rootView = createRootView();
        if (rootView) {
            var window_1 = iosApp.nativeApp.keyWindow || (iosApp.nativeApp.windows.count > 0 && iosApp.nativeApp.windows[0]);
            if (window_1) {
                var rootController = window_1.rootViewController;
                if (rootController) {
                    var controller = getViewController(rootView);
                    rootView._setupAsRootView({});
                    rootController.presentViewControllerAnimatedCompletion(controller, true, null);
                }
            }
        }
    }
}
exports.start = start;
function run(entry) {
    createRootFrame.value = false;
    start(entry);
}
exports.run = run;
function _resetRootView(entry) {
    createRootFrame.value = false;
    mainEntry = typeof entry === "string" ? { moduleName: entry } : entry;
    iosApp.setWindowContent();
}
exports._resetRootView = _resetRootView;
function getNativeApplication() {
    return iosApp.nativeApp;
}
exports.getNativeApplication = getNativeApplication;
function getViewController(view) {
    var viewController = view.viewController || view.ios;
    if (viewController instanceof UIViewController) {
        return viewController;
    }
    else {
        var nativeView = view.ios || view.nativeViewProtected;
        if (nativeView instanceof UIView) {
            viewController = view_1.ios.UILayoutViewController.initWithOwner(new WeakRef(view));
            viewController.view.addSubview(nativeView);
            view.viewController = viewController;
            return viewController;
        }
    }
    throw new Error("Root should be either UIViewController or UIView");
}
global.__onLiveSync = function () {
    if (!started) {
        return;
    }
    application_common_1.livesync();
};
//# sourceMappingURL=application.js.map